import { Component, EventEmitter, Input, NgModule, Output } from '@angular/core';
import { IonicModule } from '@ionic/angular';
import { RouteService } from 'src/app/services/route.service';

/**
 * ヘッダ
 */
@Component({
  standalone: true,
  selector: 'app-header',
  templateUrl: './header.component.html',
  styleUrls: ['./header.component.scss'],
  imports: [
    IonicModule
  ]
})
export class HeaderComponent {
  //モード(0:通常,1:閉じる,2:戻る,3:ログアウト)
  @Input() mode: number = 0;
  @Output() clickBack: EventEmitter<void> = new EventEmitter();
  @Output() clickClose: EventEmitter<void> = new EventEmitter();

  /**
   * コンストラクタ
   */
  constructor(private routeService: RouteService) { }

  /**
   * 戻る
   */
  onClickBack(): void {
    this.clickBack.emit();
  }

  /**
   * 閉じる
   */
  onClickClose(): void {
    this.clickClose.emit();
  }

  /**
   * ログアウト
   */
  onClickLogout(): void {
    this.routeService.navigateHome();
  }

}
