import { Pipe, PipeTransform } from '@angular/core';

@Pipe({
  name: 'customDate',
  standalone: true
})
export class CustomDatePipe implements PipeTransform {
  /**
   * YYYYMMDD→YYYY/MM/DD変換
   * @param value YYYYMMDD
   * @returns YYYY/MM/DD
   */
  transform(value?: string): string {
    if (!value) {
      return "";
    }
    const year = value.substring(0, 4);
    const month = value.substring(4, 6);
    const day = value.substring(6);

    return year + "/" + month + "/" + day;
  }

}
