import { NgModule } from '@angular/core';
import { PreloadAllModules, RouterModule, Routes } from '@angular/router';

const routes: Routes = [
  {
    path: 'home',
    loadChildren: () => import('./home/home.module').then(m => m.HomePageModule)
  },
  {
    path: '',
    redirectTo: 'home',
    pathMatch: 'full'
  },
  {
    path: 'user-regist',
    loadChildren: () => import('./user-regist/user-regist.module').then(m => m.UserRegistPageModule)
  },
  {
    path: 'password-update',
    loadChildren: () => import('./password-update/password-update.module').then(m => m.PasswordUpdatePageModule)
  },
  {
    path: 'menu',
    loadChildren: () => import('./menu/menu.module').then(m => m.MenuPageModule)
  },
  {
    path: 'card-select',
    loadChildren: () => import('./card-select/card-select.module').then(m => m.CardSelectPageModule)
  },
  {
    path: 'card-regist',
    loadChildren: () => import('./card-regist/card-regist.module').then(m => m.CardRegistPageModule)
  },
  {
    path: 'pass-select',
    loadChildren: () => import('./pass-select/pass-select.module').then(m => m.PassSelectPageModule)
  },
  {
    path: 'pass-regist',
    loadChildren: () => import('./pass-regist/pass-regist.module').then(m => m.PassRegistPageModule)
  },
  {
    path: 'history',
    loadChildren: () => import('./history/history.module').then(m => m.HistoryPageModule)
  },
  {
    path: 'deny-list',
    loadChildren: () => import('./deny-list/deny-list.module').then(m => m.DenyListPageModule)
  },
];

@NgModule({
  imports: [
    RouterModule.forRoot(routes, { preloadingStrategy: PreloadAllModules })
  ],
  exports: [RouterModule]
})
export class AppRoutingModule { }
