import { Injectable } from '@angular/core';
import { CommuterPassModel } from '../model/commuter-pass.model';
import { RefundModel } from '../model/refund.model';
import { Observable } from 'rxjs';

/**
 * 定期券サービス
 */
@Injectable({
  providedIn: 'root'
})
export class PassService {
  /**
   * コンストラクタ
   */
  constructor() { }

  /**
   * 定期一覧取得
   * @param tokenId トークンID
   * @return 定期一覧
   */
  getList(tokenId: string): Observable<CommuterPassModel[]> {
    //TODO
    let commuterPassList = new Array();
    for (let i = 0; i < 2; i++) {
      let model: CommuterPassModel = new CommuterPassModel();
      model.tokenId = tokenId;
      model.commuterPassId = String(i + 1);
      model.routeId = "00000" + String(i);
      model.routeName = "【◯◯◯系統】XXXXX→XXXXX行き";
      model.startDate = "2024/07/01";
      model.useTermId = "3";
      model.useTermName = "3ヶ月";
      model.priceRangeId = "1";
      model.privateRangeName = "大人";
      model.getonStopId = "1";
      model.getonStopName = "停留所1";
      model.getoffStopId = "5";
      model.getoffStopName = "停留所5";
      commuterPassList.push(model);
    }
    //return commuterPassList;
    return new Observable<CommuterPassModel[]>(o => {
      o.next(commuterPassList);
    });
  }

  /**
   * 定期一覧取得
   * @return 定期一覧
   */
  getListNoCard(): Observable<CommuterPassModel[]> {
    //TODO
    let commuterPassList = new Array();
    for (let i = 0; i < 2; i++) {
      let model: CommuterPassModel = new CommuterPassModel();
      model.commuterPassId = String(i + 1);
      model.routeId = "00000" + String(i);
      model.routeName = "【◯◯◯系統】XXXXX→XXXXX行き";
      model.startDate = "2024/07/01";
      model.useTermId = "3";
      model.useTermName = "3ヶ月";
      model.priceRangeId = "1";
      model.privateRangeName = "大人";
      model.getonStopId = "1";
      model.getonStopName = "停留所1";
      model.getoffStopId = "5";
      model.getoffStopName = "停留所5";
      commuterPassList.push(model);
    }
    //return commuterPassList;
    return new Observable<CommuterPassModel[]>(o => {
      o.next(commuterPassList);
    });
  }


  /**
   * 定期券登録
   * @param model 定期券情報
   */
  regist(model: CommuterPassModel): void {
    //TODO
  }

}
