import { Component, OnInit } from '@angular/core';
import { RouteService } from '../services/route.service';
import { CommuterPassModel } from '../model/commuter-pass.model';
import { PassService } from '../services/pass.service';

/**
 * 定期券継続画面
 */
@Component({
  selector: 'app-pass-continue',
  templateUrl: './pass-continue.page.html',
  styleUrls: ['./pass-continue.page.scss'],
})
export class PassContinuePage implements OnInit {
  public confirmButtons = [
    {
      text: 'いいえ',
      role: 'cancel'
    },
    {
      text: 'はい',
      role: 'confirm'
    },
  ];
  //カード番号
  cardNumber?: string;
  //定期券情報
  commuterPassModel?: CommuterPassModel;
  //使用期間一覧
  useTermList?: Map<string, string>;
  //使用期間ID
  useTermId?: string;
  //使用開始日
  startDate?: string;
  //金額
  price: number = 0;

  /**
   * コンストラクタ
   * @param routeService 画面遷移サービス
   * @param passService 定期券サービス
   */
  constructor(private routeService: RouteService, private passService: PassService) {
    this.cardNumber = routeService.cardNumber;
    this.commuterPassModel = routeService.commuterPassModel;
  }

  /**
   * 初期化
   */
  ngOnInit(): void {
    //使用期間一覧
    if (this.commuterPassModel) {
      this.useTermList = this.passService.getUseTermList(this.commuterPassModel?.agencyId);
      this.useTermId = this.commuterPassModel.useTermId;
      this.price = this.passService.calcPassAmount(this.commuterPassModel.agencyId, this.commuterPassModel.routeId, this.useTermId, this.commuterPassModel.priceRangeId, this.commuterPassModel.getonStopId, this.commuterPassModel.getoffStopId);
    }
  }

  /**
   * 閉じる
   */
  onClickClose(): void {
    this.routeService.navigatePassSelect(this.cardNumber);
  }

  /**
   * 定期券継続
   */
  onClickContinue(event: any): void {
    if (event.detail.role === 'confirm') {
      //定期券継続
      if (this.commuterPassModel) {
        this.commuterPassModel.useTermId = this.useTermId ? this.useTermId : "";
        this.commuterPassModel.startDate = this.startDate ? this.startDate : "";
        this.passService.continue(this.commuterPassModel);
      }
    }
    this.routeService.navigatePassSelect(this.cardNumber);
  }

  /**
   * 使用期間選択
   * @param event イベント情報 
   */
  onChangeTerm(event: any): void {
    if (this.commuterPassModel) {
      this.price = this.passService.calcPassAmount(this.commuterPassModel.agencyId, this.commuterPassModel.routeId, event.target.value, this.commuterPassModel.priceRangeId, this.commuterPassModel.getonStopId, this.commuterPassModel.getoffStopId);
    }
  }
}
