import { Component, OnInit } from '@angular/core';
import { CommuterPassModel } from '../model/commuter-pass.model';
import { RouteService } from '../services/route.service';
import { PassService } from '../services/pass.service';
import { RefundModel } from '../model/refund.model';

/**
 * 定期券払戻画面
 */
@Component({
  selector: 'app-pass-refund',
  templateUrl: './pass-refund.page.html',
  styleUrls: ['./pass-refund.page.scss'],
})
export class PassRefundPage implements OnInit {
  public confirmButtons = [
    {
      text: 'いいえ',
      role: 'cancel'
    },
    {
      text: 'はい',
      role: 'confirm'
    },
  ];
  //カード番号
  cardNumber?: string;
  //定期券情報
  commuterPassModel?: CommuterPassModel;
  //購入金額
  purchaseAmount: number = 0;
  //普通運賃
  standardFare: number = 0;
  //使用日数
  usedDays: number = 0;
  //払戻手数料
  refundFee: number = 0;
  //払戻金額
  refundAmount: number = 0;

  /**
   * コンストラクタ
   * @param routeService 画面遷移サービス
   * @param passService 定期券サービス
   */
  constructor(private routeService: RouteService, private passService: PassService) {
    this.cardNumber = routeService.cardNumber;
    this.commuterPassModel = routeService.commuterPassModel;
  }

  /**
   * 初期化
   */
  ngOnInit(): void {
    if (this.commuterPassModel && this.commuterPassModel.commuterPassId) {
      let model: RefundModel = this.passService.getRefund(this.commuterPassModel.commuterPassId);
      this.purchaseAmount = model.purchaseAmount ? model.purchaseAmount : 0;
      this.standardFare = model.standardFare ? model.standardFare : 0;
      this.usedDays = model.usedDays ? model.usedDays : 0;
      this.refundFee = model.refundFee ? model.refundFee : 0;
      this.refundAmount = model.refundAmount ? model.refundAmount : 0;
    }
  }

  /**
   * 閉じる
   */
  onClickClose(): void {
    this.routeService.navigatePassSelect(this.cardNumber);
  }

  /**
   * 払い戻し
   */
  onClickRefund(event: any): void {
    if (event.detail.role === 'confirm') {
      //定期券払戻
      if (this.commuterPassModel) {
        this.passService.refund(this.commuterPassModel);
      }
    }
    this.routeService.navigatePassSelect(this.cardNumber);
  }
}
