import { Component, OnInit } from '@angular/core';
import { RouteService } from '../services/route.service';
import { LoginService } from '../services/login.service';

/**
 * ログイン画面
 */
@Component({
  selector: 'app-home',
  templateUrl: 'home.page.html',
  styleUrls: ['home.page.scss'],
})
export class HomePage implements OnInit {
  //メールアドレス
  email?: string;
  //パスワード
  password?: string;

  /**
   * コンストラクタ
   * @param routeService 画面遷移サービス
   * @param loginService ログイン処理サービス
   */
  constructor(private routeService: RouteService, private loginService: LoginService) { }

  /**
   * 初期化
   */
  ngOnInit(): void {
    this.email = "";
    this.password = "";
  }

  /**
   * ログイン
   */
  onClickLogin(): void {
    if (!this.email) {
      alert("メールアドレスが入力されていません")
      return;
    }

    if (!this.password) {
      alert("パスワードが入力されていません");
      return;
    }

    this.loginService.login(this.email, this.password).subscribe((ret: boolean) => {
      //TODO
      if (ret) {
        this.routeService.navigateMenu("0000");
      }
    });

  }

  /**
   * 利用者登録
   */
  onClickRegist(): void {
    this.routeService.navigateUserRegist(0, "");
  }

  /**
   * パスワード更新
   */
  onClickPassword(): void {
    this.routeService.navigatePasswordUpdate();
  }
}
