import { Component } from '@angular/core';
import { RouteService } from '../services/route.service';
import { UserService } from '../services/user.service';

/**
 * パスワード更新画面
 */
@Component({
  selector: 'app-password-update',
  templateUrl: './password-update.page.html',
  styleUrls: ['./password-update.page.scss'],
})
export class PasswordUpdatePage {
  //メールアドレス
  email?: string;
  //パスワード
  password?: string;

  /**
   * コンストラクタ
   * @param routeService 画面遷移サービス
   * @param userService 利用者サービス
   */
  constructor(private routeService: RouteService, private userService: UserService) { }

  /**
   * 閉じる
   */
  onClickClose(): void {
    this.routeService.navigateHome();
  }

  /**
   * 更新
   */
  onClickUpdate(): void {
    //パスワード更新
    this.userService.changePassword(this.email, this.password);
    this.routeService.navigateHome();
  }
}
