import { Injectable } from '@angular/core';
import { Router } from '@angular/router';
import { CommuterPassModel } from '../model/commuter-pass.model';

/**
 * 画面遷移サービス
 */
@Injectable({
  providedIn: 'root'
})
export class RouteService {
  //カード番号
  cardNumber?: string;

  //定期券情報
  commuterPassModel?: CommuterPassModel;

  //モード
  mode: number = 0;

  //利用者ID
  customerId?: string;

  //トークンID
  tokenId?: string;

  /**
   * コンストラクタ
   * @param router Router
   */
  constructor(private router: Router) { }

  /**
   * ホーム画面へ遷移
   */
  navigateHome() {
    this.router.navigate(['home']);
  }

  /**
   * 利用者登録画面へ遷移
   * @param mode 0:登録、1:更新
   */
  navigateUserRegist(mode: number, customerId: string) {
    this.mode = mode;
    this.customerId = customerId;
    this.router.navigate(['user-regist']);
  }

  /**
   * パスワード更新画面へ遷移
   */
  navigatePasswordUpdate() {
    this.router.navigate(['password-update'])
  }

  /**
   * メニュー画面へ遷移
   */
  navigateMenu(customerId: string) {
    this.customerId = customerId;
    this.router.navigate(['menu']);
  }

  /**
   * クレジットカード選択画面へ遷移
   */
  navigateCardSelect() {
    this.router.navigate(['card-select'])
  }

  /**
   * クレジットカード登録画面へ遷移
   */
  navigateCardRegist() {
    this.router.navigate(['card-regist']);
  }

  /**
   * 定期券選択画面へ遷移
   * @param cardNumber カード番号
   */
  navigatePassSelect(tokenId?: string, cardNumber?: string) {
    this.tokenId = tokenId;
    this.cardNumber = cardNumber;
    this.router.navigate(['pass-select']);
  }

  /**
   * 定期券登録画面へ遷移
   */
  navigatePassRegist() {
    this.router.navigate(['pass-regist']);
  }

  /**
   * 定期券区間変更画面へ遷移
   * @param commuterPassModel 定期券情報
   */
  navigatePassChange(commuterPassModel: CommuterPassModel) {
    this.commuterPassModel = commuterPassModel;
    this.router.navigate(['pass-change']);
  }

  /**
   * 定期券継続画面へ遷移
   * @param commuterPassModel 定期券情報
   */
  navigatePassContinue(commuterPassModel: CommuterPassModel) {
    this.commuterPassModel = commuterPassModel;
    this.router.navigate(['pass-continue']);
  }

  /**
  * 定期券払戻画面へ遷移
  * @param commuterPassModel 定期券情報
  */
  navigatePassRefund(commuterPassModel: CommuterPassModel) {
    this.commuterPassModel = commuterPassModel;
    this.router.navigate(['pass-refund']);
  }

  /**
   * 乗車履歴画面へ遷移
   */
  navigateHistory() {
    this.router.navigate(['history']);
  }

  /**
   * 請求一覧画面へ遷移
   */
  navigateClaimList() {
    this.router.navigate(['claim-list']);
  }
}
