import { Component, OnInit } from '@angular/core';
import { RouteService } from '../services/route.service';
import { HistoryModel } from '../model/history.model';
import { HistoryService } from '../services/history.service';

/**
 * 乗車履歴閲覧画面
 */
@Component({
  selector: 'app-history',
  templateUrl: './history.page.html',
  styleUrls: ['./history.page.scss'],
})
export class HistoryPage implements OnInit {
  searchDate?: string;
  //乗車履歴
  historyList?: HistoryModel[];


  /**
   * コンストラクタ
   * @param routeService 画面遷移サービス
   * @param historyService 乗降履歴サービス
   */
  constructor(private routeService: RouteService, private historyService: HistoryService) { }

  /**
   * 初期化
   */
  ngOnInit(): void {
    this.searchDate = (new Date()).toLocaleDateString("ja-JP", {
      year: "numeric",
      month: "2-digit",
      day: "2-digit",
    }).split("/").join("-");
    if (this.routeService.customerId) {
      //this.historyList = this.historyService.getHistoryList(this.routeService.customerId, this.searchDate);
      this.historyService.getHistoryList(this.routeService.customerId, this.searchDate).subscribe((ret: HistoryModel[]) => {
        this.historyList = ret;
      });
    }
  }

  /**
   * 戻る
   */
  onClickBack(): void {
    if (this.routeService.customerId) {
      this.routeService.navigateMenu(this.routeService.customerId);
    }
  }

  /**
   * 前日へ
   */
  onClickBefore(): void {
    if (this.searchDate) {
      let date = new Date(this.searchDate);
      date.setDate(date.getDate() - 1);
      this.searchDate = date.toLocaleDateString("ja-JP", {
        year: "numeric",
        month: "2-digit",
        day: "2-digit",
      }).split("/").join("-");
      if (this.routeService.customerId) {
        //this.historyList = this.historyService.getHistoryList(this.routeService.customerId, this.searchDate);
        this.historyService.getHistoryList(this.routeService.customerId, this.searchDate).subscribe((ret: HistoryModel[]) => {
          this.historyList = ret;
        });
      }
    }
  }

  /**
   * 翌日へ
   */
  onClickAfter(): void {
    if (this.searchDate) {
      let date = new Date(this.searchDate);
      date.setDate(date.getDate() + 1);
      this.searchDate = date.toLocaleDateString("ja-JP", {
        year: "numeric",
        month: "2-digit",
        day: "2-digit",
      }).split("/").join("-");
      if (this.routeService.customerId) {
        //this.historyList = this.historyService.getHistoryList(this.routeService.customerId, this.searchDate);
        this.historyService.getHistoryList(this.routeService.customerId, this.searchDate).subscribe((ret: HistoryModel[]) => {
          this.historyList = ret;
        });
      }
    }
  }

  /**
   * 日付指定
   * @param event イベント情報
   */
  onChangeDate(event: any): void {
    if (this.routeService.customerId) {
      //this.historyList = this.historyService.getHistoryList(this.routeService.customerId, event.target.value);
      this.historyService.getHistoryList(this.routeService.customerId, this.searchDate).subscribe((ret: HistoryModel[]) => {
        this.historyList = ret;
      });
    }
  }
}
