import { Pipe, PipeTransform } from '@angular/core';

@Pipe({
  name: 'customDatetime',
  standalone: true
})
export class CustomDatetimePipe implements PipeTransform {
  /**
   * YYYYMMDDHHMISS→YYYY/MM/DD HH:MI:SS変換
   * @param value YYYYMMDDHHMISS→YYYY
   * @returns YYYY/MM/DD HH:MI:SS
   */
  transform(value?: string): string {
    if (!value) {
      return "";
    }
    const year = value.substring(0, 4);
    const month = value.substring(4, 6);
    const day = value.substring(6, 8);
    const hour = value.substring(8, 10);
    const min = value.substring(10, 12);
    const sec = value.substring(12);

    return year + "/" + month + "/" + day + " " + hour + ":" + min + ":" + sec;
  }
}
