import { Component, OnInit } from '@angular/core';
import { RouteService } from '../services/route.service';
import { CreditCardModel } from '../model/credit-card.model';

/**
 * クレジットカード選択
 */
@Component({
  selector: 'app-card-select',
  templateUrl: './card-select.page.html',
  styleUrls: ['./card-select.page.scss'],
})
export class CardSelectPage implements OnInit {
  cardList?: CreditCardModel[];

  /**
   * コンストラクタ
   */
  constructor(private routeService: RouteService) { }

  /**
   * 初期化
   */
  ngOnInit(): void {
    this.cardList = new Array();
    for (let i = 0; i < 2; i++) {
      let model: CreditCardModel = new CreditCardModel();
      let value = 1234 + i;
      model.cardNumber = String(value);
      model.cardOwner = "TARO YAMADA";
      model.cardYear = "2023";
      model.cardMonth = "02";
      this.cardList.push(model);
    }
  }

  /**
   * 戻る
   */
  onClickBack(): void {
    this.routeService.navigateMenu();
  }

  /**
   * クレジットカード追加
   */
  onClickAddCard(): void {
    this.routeService.navigateCardRegist();
  }

  /**
   * 定期券
   * @param model クレジットカード情報
   */
  onClickPass(model: CreditCardModel): void {
    this.routeService.navigatePassSelect(model.cardNumber);
  }

  /**
   * 削除
   * @param model クレジットカード情報
   */
  onClickTrash(model: CreditCardModel): void {

  }
}
