import { Component, OnInit, QueryList, ViewChildren } from '@angular/core';
import { DenyListModel } from '../model/deny-list.model';
import { RouteService } from '../services/route.service';
import { DenyInfoComponent } from './component/deny-info/deny-info.component';

@Component({
  selector: 'app-deny-list',
  templateUrl: './deny-list.page.html',
  styleUrls: ['./deny-list.page.scss'],
})
export class DenyListPage implements OnInit {
  public confirmButtons = [
    {
      text: 'いいえ',
      role: 'cancel'
    },
    {
      text: 'はい',
      role: 'confirm'
    },
  ];

  //拒否リスト
  denyList?: DenyListModel[];

  @ViewChildren(DenyInfoComponent) denyInfoList?: QueryList<DenyInfoComponent>;

  /**
   * コンストラクタ
   * @param routeService 画面遷移サービス
   */
  constructor(private routeService: RouteService) { }

  /**
   * 初期化
   */
  ngOnInit() {
    this.denyList = new Array();
    for (let i = 0; i < 4; i++) {
      let denyListModel = new DenyListModel();
      let str = String(i);
      denyListModel.getonStopId = str;
      denyListModel.getonStopName = "XXXX停留所";
      denyListModel.getoffStopName = "YYYYY停留所";
      denyListModel.getonDt = "2024/06/20 10:00:01";
      denyListModel.getoffDt = "2024/06/20 10:30:02";
      denyListModel.amount = 1000;
      this.denyList.push(denyListModel);
    }
  }

  /**
   * 戻る
   */
  onClickBack(): void {
    this.routeService.navigateMenu();
  }

  /**
   * 削除依頼
   */
  onClickDelreq(event: any): void {
    if (event.detail.role === 'confirm') {
      this.denyInfoList?.forEach(child => {
        let model = child.getModel();
        if (model.select) {
          //拒否リスト削除依頼
        }
      });
    }
    this.routeService.navigateMenu();
  }

}
