import { Component, OnInit } from '@angular/core';
import { CommuterPassModel } from '../model/commuter-pass.model';
import { RouteService } from '../services/route.service';

/**
 * 定期券払戻画面
 */
@Component({
  selector: 'app-pass-refund',
  templateUrl: './pass-refund.page.html',
  styleUrls: ['./pass-refund.page.scss'],
})
export class PassRefundPage implements OnInit {
  public confirmButtons = [
    {
      text: 'いいえ',
      role: 'cancel'
    },
    {
      text: 'はい',
      role: 'confirm'
    },
  ];
  //カード番号
  cardNumber?: string;
  //定期券情報
  commuterPassModel?: CommuterPassModel;
  //購入金額
  purchasePrice: number = 0;
  //普通運賃
  normalFare: number = 0;
  //使用日数
  useDays: number = 0;
  //払戻手数料
  refundFee: number = 0;
  //払戻金額
  refundPrice: number = 0;

  /**
   * コンストラクタ
   * @param routeService 画面遷移サービス
   */
  constructor(private routeService: RouteService) {
    this.cardNumber = routeService.cardNumber;
    this.commuterPassModel = routeService.commuterPassModel;
  }

  /**
   * 初期化
   */
  ngOnInit(): void {
    this.purchasePrice = 40000;
    this.normalFare = 200;
    this.useDays = 30;
    this.refundFee = 500;
    this.refundPrice = 10500;
  }

  /**
   * 閉じる
   */
  onClickClose(): void {
    this.routeService.navigatePassSelect(this.cardNumber);
  }

  /**
   * 払い戻し
   */
  onClickRefund(event: any): void {
    if (event.detail.role === 'confirm') {
      //定期券継続
    }
    this.routeService.navigatePassSelect(this.cardNumber);
  }
}
