import { Component, EventEmitter, Input, Output } from '@angular/core';
import { IonicModule } from '@ionic/angular';
import { CommuterPassModel } from 'src/app/model/commuter-pass.model';

/**
 * 定期券情報
 */
@Component({
  standalone: true,
  selector: 'app-pass-info',
  templateUrl: './pass-info.component.html',
  styleUrls: ['./pass-info.component.scss'],
  imports: [
    IonicModule
  ]
})
export class PassInfoComponent {
  @Input() model?: CommuterPassModel;
  @Output() clickChange: EventEmitter<void> = new EventEmitter();
  @Output() clickContinue: EventEmitter<void> = new EventEmitter();
  @Output() clickRefund: EventEmitter<void> = new EventEmitter();

  /**
   * コンストラクタ
   */
  constructor() { }

  /**
   * 変更
   */
  onClickChange(): void {
    this.clickChange.emit();
  }

  /**
   * 継続
   */
  onClickContinue(): void {
    this.clickContinue.emit();
  }

  /**
   * 払戻
   */
  onClickRefund(): void {
    this.clickRefund.emit();
  }
}
