import { Injectable } from '@angular/core';
import { HistoryModel } from '../model/history.model';
import { Observable } from 'rxjs';

/**
 * 乗降履歴サービス
 */
@Injectable({
  providedIn: 'root'
})
export class HistoryService {
  /**
   * コンストラクタ
   */
  constructor() { }

  /**
   * 乗降履歴一覧取得
   * @param customerId 利用者ID
   * @param searchDate 検索対象日
   * @returns 乗降履歴一覧
   */
  getHistoryList(customerId: string, searchDate?: string): Observable<HistoryModel[]> {
    //TODO
    let historyList = new Array();
    for (let i = 0; i < 10; i++) {
      let historyModel: HistoryModel = new HistoryModel();
      let str = String(i);
      if (searchDate) {
        let ymd: string[] = searchDate?.split("-");
        historyModel.getonoffDt = ymd[0] + "/" + ymd[1] + "/" + ymd[2] + " 17:08:1" + str;
      } else {
        historyModel.getonoffDt = "2024/07/01 17:08:1" + str;
      }
      historyModel.stopId = str;
      if (i % 2 == 0) {
        historyModel.kind = "1";
        historyModel.stopName = "XXXX停留所";
        historyModel.status = 1;
      } else {
        historyModel.kind = "2";
        historyModel.stopName = "YYYY停留所";
        historyModel.fare = 200;
        historyModel.status = 1;
      }
      historyList.push(historyModel);
    }
    let historyModel: HistoryModel = new HistoryModel();
    if (searchDate) {
      let ymd: string[] = searchDate?.split("-");
      historyModel.getonoffDt = ymd[0] + "/" + ymd[1] + "/" + ymd[2] + " 17:10:10";
    } else {
      historyModel.getonoffDt = "2024/07/01 17:10:10";
    }
    historyModel.kind = "1";
    historyModel.stopName = "XXXX停留所";
    historyModel.status = 0;
    historyList.push(historyModel);

    //return historyList;
    return new Observable<HistoryModel[]>(o => {
      o.next(historyList);
    });
  }
}
