import { Injectable } from '@angular/core';
import { CommuterPassModel } from '../model/commuter-pass.model';
import { RefundModel } from '../model/refund.model';
import { Observable } from 'rxjs';

/**
 * 定期券サービス
 */
@Injectable({
  providedIn: 'root'
})
export class PassService {
  /**
   * コンストラクタ
   */
  constructor() { }

  /**
   * 定期一覧取得
   * @param tokenId トークンID
   * @return 定期一覧
   */
  getList(tokenId: string): Observable<CommuterPassModel[]> {
    //TODO
    let commuterPassList = new Array();
    for (let i = 0; i < 2; i++) {
      let model: CommuterPassModel = new CommuterPassModel();
      model.tokenId = tokenId;
      model.commuterPassId = String(i + 1);
      model.routeId = "00000" + String(i);
      model.routeName = "【◯◯◯系統】XXXXX→XXXXX行き";
      model.startDate = "2024/07/01";
      model.useTermId = "3";
      model.useTermName = "3ヶ月";
      model.priceRangeId = "1";
      model.privateRangeName = "大人";
      model.getonStopId = "1";
      model.getonStopName = "停留所1";
      model.getoffStopId = "5";
      model.getoffStopName = "停留所5";
      commuterPassList.push(model);
    }
    //return commuterPassList;
    return new Observable<CommuterPassModel[]>(o => {
      o.next(commuterPassList);
    });
  }

  /**
   * 定期券登録
   * @param model 定期券情報
   */
  regist(model: CommuterPassModel): void {
    //TODO
  }

  /**
   * 定期券区間変更
   * @param model 定期券情報
   */
  change(model: CommuterPassModel): void {
    //TODO
  }

  /**
   * 定期券継続
   * @param model 定期券情報
   */
  continue(model: CommuterPassModel): void {
    //TODO
  }

  /**
   * 定期券払戻
   * @param model 定期券情報
   */
  refund(model: CommuterPassModel): void {
    //TODO
  }

  /**
   * 路線一覧取得
   * @param agencyId 事業者ID
   * @returns 路線一覧
   */
  getRouteList(agencyId: string): Observable<Map<string, string>> {
    //路線一覧
    let routeList = new Map();
    for (let i = 0; i < 5; i++) {
      let str = String(i + 1);
      routeList.set(str, "路線" + str);
    }
    //return routeList;
    return new Observable<Map<string, string>>(o => {
      o.next(routeList);
    })
  }

  /**
   * 使用期間一覧取得
   * @param agencyId 事業者ID
   * @returns 使用期間一覧
   */
  getUseTermList(agencyId: string): Observable<Map<string, string>> {
    let useTermList = new Map();
    useTermList.set("1", "1ヶ月");
    useTermList.set("3", "3ヶ月");
    useTermList.set("6", "6ヶ月");

    //return useTermList;
    return new Observable<Map<string, string>>(o => {
      o.next(useTermList);
    })
  }

  /**
   * 料金区分一覧取得
   * @param agencyId 事業者ID
   * @returns 料金区分一覧
   */
  getPriceRangeList(agencyId: string): Observable<Map<string, string>> {
    let priceRangeList = new Map();
    priceRangeList.set("1", "大人");
    priceRangeList.set("2", "小児");
    priceRangeList.set("3", "学生");
    //return priceRangeList;
    return new Observable<Map<string, string>>(o => {
      o.next(priceRangeList);
    })
  }

  /**
   * 停留所一覧取得
   * @param agencyId 事業者ID
   * @param routeId 路線ID
   * @returns 停留所一覧
   */
  getStopList(agencyId: string, routeId: string): Observable<Map<string, string>> {
    let stopList = new Map();
    for (let i = 0; i < 5; i++) {
      let str = String(i + 1);
      stopList.set(str, "停留所" + str);
    }
    //return stopList;
    return new Observable<Map<string, string>>(o => {
      o.next(stopList);
    })
  }

  /**
   * 定期券料金計算
   * 
   * @param agencyId 事業者ID
   * @param routeId 路線ID 
   * @param useTermId 使用期間
   * @param priceRangeId 料金区分
   * @param getonStopId 乗車停留所
   * @param getoffStopId 降車停留所
   */
  calcPassAmount(agencyId: string, routeId?: string, useTermId?: string, priceRangeId?: string, getonStopId?: string, getoffStopId?: string): number {
    //TODO
    //以下はダミー
    //通常運賃
    let getonStop = Number(getonStopId);
    let getoffStop = Number(getoffStopId);
    let unit = (getoffStop - getonStop) >= 0 ? (getoffStop - getonStop) : (getonStop - getoffStop);
    unit = unit * 100;

    let one = unit * 30 * 0.75;
    let three = one * 3 * 0.95;
    let six = one * 6 * 0.9;

    let ret = 0;
    if (useTermId == "1") {
      ret = one;
    } else if (useTermId == "2") {
      ret = three;
    } else {
      ret = six;
    }

    if (priceRangeId == "2") {
      ret = ret * 0.5;
    } else if (priceRangeId == "3") {
      ret = ret * 0.6;
    }

    return Math.floor(ret);
  }

  /**
   * 定期券払戻料金計算
   * @param agencyId 事業者ID
   * @param routeId 路線ID
   * @param startDate 使用開始日
   * @param useTermId 使用期間
   * @param priceRangeId 料金区分
   * @param getonStopId 乗車停留所ID
   * @param getoffStopId 降車停留所ID
   */
  calcRefundAmount(agencyId: string, routeId?: string, startDate?: string, useTermId?: string, priceRangeId?: string, getonStopId?: string, getoffStopId?: string, purchaseAmount?: number): number {
    //TODO
    //以下はダミー
    //通常運賃
    let getonStop = Number(getonStopId);
    let getoffStop = Number(getoffStopId);
    let unit = (getoffStop - getonStop) >= 0 ? (getoffStop - getonStop) : (getonStop - getoffStop);
    unit = unit * 100;

    if (priceRangeId == "2") {
      unit = unit * 0.5;
    } else if (priceRangeId == "3") {
      unit = unit * 0.6;
    }

    //残日数計算
    let termDay = 0;
    let now = new Date();
    if (startDate) {
      let start = new Date(startDate);
      termDay = (now.getTime() - start.getTime()) / 86400000;
    }
    if (useTermId == "1") {
      termDay = 30 - termDay;
    } else if (useTermId == "3") {
      termDay = 90 - termDay;
    } else if (useTermId == "6") {
      termDay = 180 - termDay;
    }

    let amount = 0;
    if (purchaseAmount) {
      amount = purchaseAmount - (termDay * unit) - 500;
    }

    amount = amount < 0 ? 0 : amount;

    return Math.floor(amount);
  }

  /**
   * 払戻情報取得
   * @param commuterPassId 定期券ID
   */
  getRefund(commuterPassId: string): RefundModel {
    //TODO
    //↓以下はダミー
    let ret = new RefundModel();
    ret.purchaseAmount = this.calcPassAmount("", "", "3", "1", "1", "5");
    //通常運賃
    let getonStop = 1;
    let getoffStop = 5;
    let unit = (getoffStop - getonStop) >= 0 ? (getoffStop - getonStop) : (getonStop - getoffStop);
    ret.standardFare = unit * 100;

    //使用日数計算
    let now = new Date();
    let start = new Date("2024/07/01");
    ret.usedDays = Math.floor((now.getTime() - start.getTime()) / 86400000);

    //残日数
    let termDay = 90 - ret.usedDays;

    //払戻手数料
    ret.refundFee = 500;

    let amount = ret.purchaseAmount - (termDay * ret.standardFare) - ret.refundFee;

    amount = amount < 0 ? 0 : amount;

    ret.refundAmount = Math.floor(amount);

    return ret;
  }
}
