import { Component, OnInit } from '@angular/core';
import { RouteService } from '../services/route.service';
import { UserService } from '../services/user.service';
import { UserInfoModel } from '../model/user-info.model';

/**
 * 利用者登録画面
 */
@Component({
  selector: 'app-user-regist',
  templateUrl: './user-regist.page.html',
  styleUrls: ['./user-regist.page.scss'],
})
export class UserRegistPage implements OnInit {
  //モード(0:登録、1:更新)
  mode: number = 0;
  //氏名
  name?: string;
  //フリガナ
  nameKana?: string;
  //電話番号
  phoneNumber?: string;
  //メールアドレス
  email?: string;
  //パスワード
  password?: string;
  //利用者ID
  customerId?: string;

  public confirmButtons = [
    {
      text: 'いいえ',
      role: 'cancel'
    },
    {
      text: 'はい',
      role: 'confirm'
    },
  ];

  /**
   * コンストラクタ
   * @param routeService 画面遷移サービス
   * @param userService 利用者情報サービス
   */
  constructor(private routeService: RouteService, private userService: UserService) {
    this.mode = routeService.mode;
    this.customerId = routeService.customerId;
  }

  /**
   * 初期処理
   */
  ngOnInit(): void {
    if (this.customerId) {
      //let model: UserInfoModel = this.userService.getInfo(this.customerId);
      this.userService.getInfo(this.customerId).subscribe((model: UserInfoModel) => {
        this.name = model.name;
        this.nameKana = model.nameKana;
        this.phoneNumber = model.phoneNumber;
        this.email = model.email;
        this.password = model.password;
      });
    }
  }

  /**
   * 閉じる
   */
  onClickClose(): void {
    this.routeService.navigateHome();
  }

  /**
   * 登録
   * @param event イベント情報
   */
  onClickRegist(event: any): void {
    if (event.detail.role === 'confirm') {
      //利用者情報登録
      let model: UserInfoModel = new UserInfoModel();
      model.name = this.name;
      model.nameKana = this.nameKana;
      model.phoneNumber = this.phoneNumber;
      model.email = this.email;
      model.password = this.password;
      this.userService.regist(model);
    }
    this.routeService.navigateHome();
  }

  /**
   * 更新
   * @param event イベント情報
   */
  onClickUpdate(event: any): void {
    if (event.detail.role === 'confirm') {
      //利用者情報更新
      let model: UserInfoModel = new UserInfoModel();
      model.customerId = this.customerId;
      model.name = this.name;
      model.nameKana = this.nameKana;
      model.phoneNumber = this.phoneNumber;
      model.email = this.email;
      model.password = this.password;
      this.userService.update(model);
    }
    this.routeService.navigateHome();
  }

  /**
   * 退会
   * @param event イベント情報
   */
  onClickWithdraw(event: any): void {
    if (event.detail.role === 'confirm') {
      //退会
      if (this.customerId) {
        this.userService.withdraw(this.customerId);
      }
    }
    this.routeService.navigateHome();
  }
}
