import { Component } from '@angular/core';
import { RouteService } from '../services/route.service';

/**
 * クレジットカード登録画面
 */
@Component({
  selector: 'app-card-regist',
  templateUrl: './card-regist.page.html',
  styleUrls: ['./card-regist.page.scss'],
})
export class CardRegistPage {
  public confirmButtons = [
    {
      text: 'いいえ',
      role: 'cancel'
    },
    {
      text: 'はい',
      role: 'confirm'
    },
  ];

  //カード番号
  cardNumber?: string;
  //カード名義人
  cardOwner?: string;
  //有効期限-月
  cardMonth?: string;
  //有効期限-年
  cardYear?: string;
  //CVC
  cvc?: string;


  /**
   * コンストラクタ
   * @param routeService 画面遷移サービス
   */
  constructor(private routeService: RouteService) { }

  /**
   * 閉じる
   */
  onClickClose(): void {
    this.routeService.navigateCardSelect();
  }

  /**
   * 追加
   * @param event イベント
   */
  onClickAddCard(event: any): void {
    this.routeService.navigateCardSelect();
  }
}
