import { Component } from '@angular/core';
import { RouteService } from '../services/route.service';

/**
 * ログイン画面
 */
@Component({
  selector: 'app-home',
  templateUrl: 'home.page.html',
  styleUrls: ['home.page.scss'],
})
export class HomePage {
  //メールアドレス
  email?: string;
  //パスワード
  password?: string;

  /**
   * コンストラクタ
   * @param routeService 画面遷移サービス
   */
  constructor(private routeService: RouteService) { }

  /**
   * ログイン
   */
  onClickLogin(): void {
    this.routeService.navigateMenu();
  }

  /**
   * 利用者登録
   */
  onClickRegist(): void {
    this.routeService.navigateUserRegist();
  }

  /**
   * パスワード更新
   */
  onClickPassword(): void {
    this.routeService.navigatePasswordUpdate();
  }
}
