import { Component, Input, OnInit } from '@angular/core';
import { CommuterPassModel } from '../model/commuter-pass.model';
import { RouteService } from '../services/route.service';

/**
 * 定期券区間変更画面
 */
@Component({
  selector: 'app-pass-change',
  templateUrl: './pass-change.page.html',
  styleUrls: ['./pass-change.page.scss'],
})
export class PassChangePage implements OnInit {
  public confirmButtons = [
    {
      text: 'いいえ',
      role: 'cancel'
    },
    {
      text: 'はい',
      role: 'confirm'
    },
  ];
  //カード番号
  cardNumber?: string;
  //定期券情報
  commuterPassModel?: CommuterPassModel;
  //停留所一覧
  stopList?: Map<string, string>;
  //変更後乗車停留所ID
  getonStopId?: string;
  //変更後降車停留所ID
  getoffStopId?: string;
  //購入金額
  purchasePrice: number = 0;
  //払戻金額
  refundPrice: number = 0;

  /**
   * コンストラクタ
   * @param routeService 画面遷移サービス
   */
  constructor(private routeService: RouteService) {
    this.cardNumber = routeService.cardNumber;
    this.commuterPassModel = routeService.commuterPassModel;
  }

  /**
   * 初期化
   */
  ngOnInit(): void {
    //停留所一覧
    this.stopList = new Map();
    for (let i = 0; i < 5; i++) {
      let str = String(i + 1);
      this.stopList.set(str, "停留所" + str);
    }
  }

  /**
   * 閉じる
   */
  onClickClose(): void {
    this.routeService.navigatePassSelect(this.cardNumber);
  }

  /**
   * 定期券区間変更
   */
  onClickChange(event: any): void {
    if (event.detail.role === 'confirm') {
      //定期券区間変更
    }
    this.routeService.navigatePassSelect(this.cardNumber);
  }
}
