import { KeyValue } from '@angular/common';
import { Component, OnInit } from '@angular/core';
import { RouteService } from '../services/route.service';

/**
 * 定期券登録画面
 */
@Component({
  selector: 'app-pass-regist',
  templateUrl: './pass-regist.page.html',
  styleUrls: ['./pass-regist.page.scss'],
})
export class PassRegistPage implements OnInit {
  public confirmButtons = [
    {
      text: 'いいえ',
      role: 'cancel'
    },
    {
      text: 'はい',
      role: 'confirm'
    },
  ];


  //路線一覧
  routeList?: Map<string, string>;
  //使用期間一覧
  useTermList?: Map<string, string>;
  //料金区分一覧
  priceRangeList?: Map<string, string>;
  //停留所一覧
  stopList?: Map<string, string>;

  //路線
  routeId?: string;
  //使用期間
  useTermId?: string;
  //料金区分
  priceRangeId?: string;
  //使用開始日
  startDate?: string;
  //乗車停留所
  getonStopId?: string;
  //区間
  getoffStopId?: string;
  //支払金額
  price: number = 0;

  /**
   * コンストラクタ
   * @param routeService 画面遷移サービス
   */
  constructor(private routeService: RouteService) { }

  /**
   * 初期化
   */
  ngOnInit(): void {
    //路線一覧
    this.routeList = new Map();
    for (let i = 0; i < 5; i++) {
      let str = String(i + 1);
      this.routeList.set(str, "路線" + str);
    }

    //使用期間一覧
    this.useTermList = new Map();
    this.useTermList.set("1", "1ヶ月");
    this.useTermList.set("2", "3ヶ月");
    this.useTermList.set("6", "6ヶ月");

    //料金区分一覧
    this.priceRangeList = new Map();
    this.priceRangeList.set("1", "大人");
    this.priceRangeList.set("2", "小児");
    this.priceRangeList.set("3", "学生");

    //停留所一覧
    this.stopList = new Map();
    for (let i = 0; i < 5; i++) {
      let str = String(i + 1);
      this.stopList.set(str, "停留所" + str);
    }
  }

  /**
   * 閉じる
   */
  onClickClose(): void {
    this.routeService.navigatePassSelect(this.routeService.cardNumber);
  }

  /**
   * 追加
   */
  onClickAdd(event: any): void {
    if (event.detail.role === 'confirm') {
      //定期券登録
    }
    this.routeService.navigatePassSelect(this.routeService.cardNumber);
  }
}
