import { Component, OnInit } from '@angular/core';
import { CommuterPassModel } from '../model/commuter-pass.model';
import { RouteService } from '../services/route.service';

/**
 * 定期券選択画面
 */
@Component({
  selector: 'app-pass-select',
  templateUrl: './pass-select.page.html',
  styleUrls: ['./pass-select.page.scss'],
})
export class PassSelectPage implements OnInit {
  //カード番号
  cardNumber?: string;
  //定期券情報
  commuterPassList?: CommuterPassModel[];

  /**
   * コンストラクタ
   * @param routeService 画面遷移サービス
   */
  constructor(private routeService: RouteService) {
    this.cardNumber = routeService.cardNumber;
  }

  /**
   * 初期化
   */
  ngOnInit() {
    this.commuterPassList = new Array();
    for (let i = 0; i < 2; i++) {
      let model: CommuterPassModel = new CommuterPassModel();
      model.routeId = "00000" + String(i);
      model.routeName = "【◯◯◯系統】XXXXX→XXXXX行き";
      model.startDate = "2024/07/01";
      model.useTermId = "2";
      model.useTermName = "3ヶ月";
      model.priceRangeId = "0";
      model.privateRangeName = "大人";
      model.getonStopName = "XXXXX";
      model.getoffStopName = "XXXXX";
      this.commuterPassList.push(model);
    }
  }

  /**
   * 戻る
   */
  onClickBack(): void {
    this.routeService.navigateCardSelect();
  }

  /**
   * 定期券区間変更
   * @param model 定期券情報
   */
  onClickChange(model: CommuterPassModel) {
    this.routeService.navigatePassChange(model);
  }

  /**
   * 定期券継続
   * @param model 定期券情報
   */
  onClickContinue(model: CommuterPassModel) {
    this.routeService.navigatePassContinue(model);
  }

  /**
   * 定期券払戻
   * @param model 定期券情報
   */
  onClickRefund(model: CommuterPassModel) {
    this.routeService.navigatePassRefund(model);
  }

  /**
   * 定期券登録
   */
  onClickAddPass() {
    this.routeService.navigatePassRegist();
  }
}
