import { Component, OnInit, QueryList, ViewChildren } from '@angular/core';
import { DenyListModel } from '../model/deny-list.model';
import { RouteService } from '../services/route.service';
import { DenyInfoComponent } from './component/deny-info/deny-info.component';
import { DenylistService } from '../services/denylist.service';

@Component({
  selector: 'app-deny-list',
  templateUrl: './deny-list.page.html',
  styleUrls: ['./deny-list.page.scss'],
})
export class DenyListPage implements OnInit {
  public confirmButtons = [
    {
      text: 'いいえ',
      role: 'cancel'
    },
    {
      text: 'はい',
      role: 'confirm'
    },
  ];

  //拒否リスト
  denyList?: DenyListModel[];

  @ViewChildren(DenyInfoComponent) denyInfoList?: QueryList<DenyInfoComponent>;

  /**
   * コンストラクタ
   * @param routeService 画面遷移サービス
   * @param denyListService 拒否リストサービス
   */
  constructor(private routeService: RouteService, private denyListService: DenylistService) { }

  /**
   * 初期化
   */
  ngOnInit() {
    if (this.routeService.customerId) {
      this.denyList = this.denyListService.getList(this.routeService.customerId);
    }
  }

  /**
   * 戻る
   */
  onClickBack(): void {
    if (this.routeService.customerId) {
      this.routeService.navigateMenu(this.routeService.customerId);
    }
  }

  /**
   * 削除依頼
   */
  onClickDelreq(event: any): void {
    if (event.detail.role === 'confirm') {
      let req: DenyListModel[] = [];
      this.denyInfoList?.forEach(child => {
        let model = child.getModel();
        if (model.select) {
          //拒否リスト削除依頼
          req.push(model);
        }
      });
      this.denyListService.reqDelete(req);
    }
    if (this.routeService.customerId) {
      this.routeService.navigateMenu(this.routeService.customerId);
    }
  }

}
