import { Injectable } from '@angular/core';
import { HistoryModel } from '../model/history.model';

@Injectable({
  providedIn: 'root'
})
export class HistoryService {

  constructor() { }

  /**
   * 乗降履歴一覧取得
   * @param customerId 利用者ID
   * @returns 乗降履歴一覧
   */
  getHistoryList(customerId: string): HistoryModel[] {
    let historyList = new Array();
    for (let i = 0; i < 10; i++) {
      let historyModel: HistoryModel = new HistoryModel();
      let str = String(i);
      historyModel.getonoffDt = "2024/06/19 17:08:1" + str;
      historyModel.stopId = str;
      if (i % 2 == 0) {
        historyModel.kind = "1";
        historyModel.stopName = "XXXX停留所";
        historyModel.status = 1;
      } else {
        historyModel.kind = "2";
        historyModel.stopName = "YYYY停留所";
        historyModel.fare = 200;
        historyModel.status = 1;
      }
      historyList.push(historyModel);
    }
    let historyModel: HistoryModel = new HistoryModel();
    historyModel.getonoffDt = "2024/06/19 17:10:10";
    historyModel.kind = "1";
    historyModel.stopName = "XXXX停留所";
    historyModel.status = 0;
    historyList.push(historyModel);

    return historyList;
  }
}
