import { Component, OnInit } from '@angular/core';
import { RouteService } from '../services/route.service';
import { CreditCardModel } from '../model/credit-card.model';
import { CardService } from '../services/card.service';

/**
 * クレジットカード選択
 */
@Component({
  selector: 'app-card-select',
  templateUrl: './card-select.page.html',
  styleUrls: ['./card-select.page.scss'],
})
export class CardSelectPage implements OnInit {
  cardList?: CreditCardModel[];

  /**
   * コンストラクタ
   * @param routeService 画面遷移サービス
   * @param cardService クレジットカードサービス
   */
  constructor(private routeService: RouteService, private cardService: CardService) { }

  /**
   * 初期化
   */
  ngOnInit(): void {
    this.cardList = this.cardService.getList(this.routeService.customerId);
  }

  /**
   * 戻る
   */
  onClickBack(): void {
    if (this.routeService.customerId) {
      this.routeService.navigateMenu(this.routeService.customerId);
    }
  }

  /**
   * クレジットカード追加
   */
  onClickAddCard(): void {
    this.routeService.navigateCardRegist();
  }

  /**
   * 定期券
   * @param model クレジットカード情報
   */
  onClickPass(model: CreditCardModel): void {
    this.routeService.navigatePassSelect(model.tokenId, model.cardNumber);
  }

  /**
   * 削除
   * @param model クレジットカード情報
   */
  onClickTrash(model: CreditCardModel): void {
    this.cardService.delete(model.tokenId);
  }
}
