import { Component, OnInit } from '@angular/core';
import { RouteService } from '../services/route.service';
import { HistoryModel } from '../model/history.model';
import { HistoryService } from '../services/history.service';

/**
 * 乗車履歴閲覧画面
 */
@Component({
  selector: 'app-history',
  templateUrl: './history.page.html',
  styleUrls: ['./history.page.scss'],
})
export class HistoryPage implements OnInit {
  //乗車履歴
  historyList?: HistoryModel[];


  /**
   * コンストラクタ
   * @param routeService 画面遷移サービス
   * @parma historyService 乗降履歴サービス
   */
  constructor(private routeService: RouteService, private historyService: HistoryService) { }

  /**
   * 初期化
   */
  ngOnInit() {
    if (this.routeService.customerId) {
      this.historyList = this.historyService.getHistoryList(this.routeService.customerId);
    }
  }

  /**
   * 戻る
   */
  onClickBack(): void {
    if (this.routeService.customerId) {
      this.routeService.navigateMenu(this.routeService.customerId);
    }
  }
}
