import { Component } from '@angular/core';
import { RouteService } from '../services/route.service';
import { LoginService } from '../services/login.service';

/**
 * ログイン画面
 */
@Component({
  selector: 'app-home',
  templateUrl: 'home.page.html',
  styleUrls: ['home.page.scss'],
})
export class HomePage {
  //メールアドレス
  email?: string;
  //パスワード
  password?: string;

  /**
   * コンストラクタ
   * @param routeService 画面遷移サービス
   * @param loginService ログイン処理サービス
   */
  constructor(private routeService: RouteService, private loginService: LoginService) { }

  /**
   * ログイン
   */
  onClickLogin(): void {
    if (!this.email) {
      alert("メールアドレスが入力されていません")
      return;
    }

    if (!this.password) {
      alert("パスワードが入力されていません");
      return;
    }

    if (this.loginService.login(this.email, this.password)) {
      //TODO
      this.routeService.navigateMenu("0000");
    }
  }

  /**
   * 利用者登録
   */
  onClickRegist(): void {
    this.routeService.navigateUserRegist(0, "");
  }

  /**
   * パスワード更新
   */
  onClickPassword(): void {
    this.routeService.navigatePasswordUpdate();
  }
}
