import { KeyValue } from '@angular/common';
import { Component, OnInit } from '@angular/core';
import { RouteService } from '../services/route.service';
import { CommuterPassModel } from '../model/commuter-pass.model';
import { PassService } from '../services/pass.service';

/**
 * 定期券登録画面
 */
@Component({
  selector: 'app-pass-regist',
  templateUrl: './pass-regist.page.html',
  styleUrls: ['./pass-regist.page.scss'],
})
export class PassRegistPage implements OnInit {
  public confirmButtons = [
    {
      text: 'いいえ',
      role: 'cancel'
    },
    {
      text: 'はい',
      role: 'confirm'
    },
  ];


  //路線一覧
  routeList?: Map<string, string>;
  //使用期間一覧
  useTermList?: Map<string, string>;
  //料金区分一覧
  priceRangeList?: Map<string, string>;
  //停留所一覧
  stopList?: Map<string, string>;

  //路線
  routeId?: string;
  //使用期間
  useTermId?: string;
  //料金区分
  priceRangeId?: string;
  //使用開始日
  startDate?: string;
  //乗車停留所
  getonStopId?: string;
  //区間
  getoffStopId?: string;
  //支払金額
  price: number = 0;
  //事業者ID
  agencyId: string = "";

  /**
   * コンストラクタ
   * @param routeService 画面遷移サービス
   * @param passService 定期券サービス
   */
  constructor(private routeService: RouteService, private passService: PassService) { }

  /**
   * 初期化
   */
  ngOnInit(): void {

    //路線一覧
    //TODO 事業者IDはどうやって決める?
    this.routeList = this.passService.getRouteList(this.agencyId);

    //使用期間一覧
    this.useTermList = this.passService.getUseTermList(this.agencyId);

    //料金区分一覧
    this.priceRangeList = this.passService.getPriceRangeList(this.agencyId);

    //停留所一覧
    this.stopList = this.passService.getStopList(this.agencyId, this.routeList.values().next().value);
  }

  /**
   * 路線選択
   * @param event イベント情報
   */
  onChangeRoute(event: any): void {
    this.stopList = this.passService.getStopList(this.agencyId, event.target.value);
  }

  /**
   * 閉じる
   */
  onClickClose(): void {
    this.routeService.navigatePassSelect(this.routeService.cardNumber);
  }

  /**
   * 追加
   */
  onClickAdd(event: any): void {
    if (event.detail.role === 'confirm') {
      //定期券登録
      let model: CommuterPassModel = new CommuterPassModel();
      model.tokenId = this.routeService.tokenId;
      model.routeId = this.routeId ? this.routeId : "";
      model.startDate = this.startDate ? this.startDate : "";
      model.useTermId = this.useTermId ? this.useTermId : "";
      model.priceRangeId = this.priceRangeId ? this.priceRangeId : "";
      model.getonStopId = this.getonStopId ? this.getonStopId : "";
      model.getoffStopId = this.getoffStopId ? this.getoffStopId : "";
      this.passService.regist(model);
    }
    this.routeService.navigatePassSelect(this.routeService.cardNumber);
  }
}
