import { Component } from '@angular/core';
import { RouteService } from '../services/route.service';

/**
 * パスワード更新画面
 */
@Component({
  selector: 'app-password-update',
  templateUrl: './password-update.page.html',
  styleUrls: ['./password-update.page.scss'],
})
export class PasswordUpdatePage {
  //メールアドレス
  email?: string;
  //パスワード
  password?: string;

  /**
   * コンストラクタ
   * @param routeService 画面遷移サービス
   */
  constructor(private routeService: RouteService) { }

  /**
   * 閉じる
   */
  onClickClose(): void {
    this.routeService.navigateHome();
  }

  /**
   * 更新
   */
  onClickUpdate(): void {
    //パスワード更新

    this.routeService.navigateHome();
  }
}
