import { Component, OnInit } from '@angular/core';
import { RouteService } from '../services/route.service';
import { HistoryModel } from '../model/history.model';

/**
 * 乗車履歴閲覧画面
 */
@Component({
  selector: 'app-history',
  templateUrl: './history.page.html',
  styleUrls: ['./history.page.scss'],
})
export class HistoryPage implements OnInit {
  //乗車履歴
  historyList?: HistoryModel[];


  /**
   * コンストラクタ
   * @param routeService 画面遷移サービス
   */
  constructor(private routeService: RouteService) { }

  /**
   * 初期化
   */
  ngOnInit() {
    this.historyList = new Array();
    for (let i = 0; i < 10; i++) {
      let historyModel: HistoryModel = new HistoryModel();
      let str = String(i);
      historyModel.getonoffDt = "2024/06/19 17:08:1" + str;
      historyModel.stopId = str;
      if (i % 2 == 0) {
        historyModel.kind = "1";
        historyModel.stopName = "XXXX停留所";
        historyModel.status = 1;
      } else {
        historyModel.kind = "2";
        historyModel.stopName = "YYYY停留所";
        historyModel.fare = 200;
        historyModel.status = 1;
      }
      this.historyList.push(historyModel);
    }
    let historyModel: HistoryModel = new HistoryModel();
    historyModel.getonoffDt = "2024/06/19 17:10:10";
    historyModel.kind = "1";
    historyModel.stopName = "XXXX停留所";
    historyModel.status = 0;
    this.historyList.push(historyModel);
  }

  /**
   * 戻る
   */
  onClickBack(): void {
    this.routeService.navigateMenu();
  }

  /**
   * 前の10件
   */
  onClickPrev(): void {

  }

  /**
   * 次の10件
   */
  onClickNext(): void {

  }
}
