import { Component, OnInit } from '@angular/core';
import { RouteService } from '../services/route.service';
import { CommuterPassModel } from '../model/commuter-pass.model';

/**
 * 定期券継続画面
 */
@Component({
  selector: 'app-pass-continue',
  templateUrl: './pass-continue.page.html',
  styleUrls: ['./pass-continue.page.scss'],
})
export class PassContinuePage implements OnInit {
  public confirmButtons = [
    {
      text: 'いいえ',
      role: 'cancel'
    },
    {
      text: 'はい',
      role: 'confirm'
    },
  ];
  //カード番号
  cardNumber?: string;
  //定期券情報
  commuterPassModel?: CommuterPassModel;
  //使用期間一覧
  useTermList?: Map<string, string>;
  //使用期間ID
  useTermId?: string;
  //使用開始日
  startDate?: string;
  //金額
  price: number = 0;

  /**
   * コンストラクタ
   * @param routeService 画面遷移サービス
   */
  constructor(private routeService: RouteService) {
    this.cardNumber = routeService.cardNumber;
    this.commuterPassModel = routeService.commuterPassModel;
  }

  /**
   * 初期化
   */
  ngOnInit(): void {
    //使用期間一覧
    this.useTermList = new Map();
    this.useTermList.set("1", "1ヶ月");
    this.useTermList.set("2", "3ヶ月");
    this.useTermList.set("6", "6ヶ月");
  }

  /**
   * 閉じる
   */
  onClickClose(): void {
    this.routeService.navigatePassSelect(this.cardNumber);
  }

  /**
   * 定期券継続
   */
  onClickContinue(event: any): void {
    if (event.detail.role === 'confirm') {
      //定期券継続
    }
    this.routeService.navigatePassSelect(this.cardNumber);
  }
}
