import { Component, OnInit } from '@angular/core';
import { RouteService } from '../services/route.service';

/**
 * 利用者登録画面
 */
@Component({
  selector: 'app-user-regist',
  templateUrl: './user-regist.page.html',
  styleUrls: ['./user-regist.page.scss'],
})
export class UserRegistPage {
  //モード(0:登録、1:更新)
  mode: number = 0;
  //氏名
  name?: string;
  //フリガナ
  nameKana?: string;
  //電話番号
  phoneNumber?: string;
  //メールアドレス
  email?: string;
  //パスワード
  password?: string;

  public confirmButtons = [
    {
      text: 'いいえ',
      role: 'cancel'
    },
    {
      text: 'はい',
      role: 'confirm'
    },
  ];

  /**
   * コンストラクタ
   * @param routeService 画面遷移サービス
   */
  constructor(private routeService: RouteService) { }

  /**
   * 閉じる
   */
  onClickClose(): void {
    this.routeService.navigateHome();
  }

  /**
   * 登録
   * @param event イベント情報
   */
  onClickRegist(event: any): void {
    if (event.detail.role === 'confirm') {
      //利用者情報登録
    }
    this.routeService.navigateHome();
  }

  /**
   * 更新
   * @param event イベント情報
   */
  onClickUpdate(event: any): void {
    if (event.detail.role === 'confirm') {
      //利用者情報更新
    }
    this.routeService.navigateHome();
  }

  /**
   * 退会
   * @param event イベント情報
   */
  onClickWithdraw(event: any): void {
    if (event.detail.role === 'confirm') {
      //退会
    }
    this.routeService.navigateHome();
  }

}
