import { Component } from '@angular/core';
import { RouteService } from '../services/route.service';
import { CardService } from '../services/card.service';
import { CreditCardModel } from '../model/credit-card.model';

/**
 * クレジットカード登録画面
 */
@Component({
  selector: 'app-card-regist',
  templateUrl: './card-regist.page.html',
  styleUrls: ['./card-regist.page.scss'],
})
export class CardRegistPage {
  public confirmButtons = [
    {
      text: 'いいえ',
      role: 'cancel'
    },
    {
      text: 'はい',
      role: 'confirm'
    },
  ];

  //カード番号
  cardNumber?: string;
  //カード名義人
  cardOwner?: string;
  //有効期限-月
  cardMonth?: string;
  //有効期限-年
  cardYear?: string;
  //CVC
  cvc?: string;


  /**
   * コンストラクタ
   * @param routeService 画面遷移サービス
   * @param cardService クレジットカードサービス
   */
  constructor(private routeService: RouteService, private cardService: CardService) { }

  /**
   * 閉じる
   */
  onClickClose(): void {
    this.routeService.navigateCardSelect();
  }

  /**
   * 追加
   * @param event イベント
   */
  onClickAddCard(event: any): void {
    //クレジットカード登録
    let model: CreditCardModel = new CreditCardModel();
    model.cardNumber = this.cardMonth ? this.cardMonth : "";
    model.cardOwner = this.cardOwner ? this.cardOwner : "";
    model.cardMonth = this.cardMonth ? this.cardMonth : "";
    model.cardYear = this.cardYear ? this.cardYear : "";
    model.cvc = this.cvc ? this.cvc : "";
    this.cardService.regist(this.routeService.customerId, model);

    this.routeService.navigateCardSelect();
  }
}
