import { Injectable } from '@angular/core';
import { ClaimListModel } from '../model/claim-list.model';
import { Observable } from 'rxjs';
import { HttpClient } from '@angular/common/http';

/**
 * 請求一覧サービス
 */
@Injectable({
  providedIn: 'root'
})
export class ClaimlistService {
  readonly claimUrl = './data/claimlist.json';

  /**
   * コンストラクタ
   */
  constructor(private http: HttpClient) { }

  /**
   * 請求一覧取得
   * @param customerId 利用者ID
   * @return 請求一覧
   */
  getList(customerId: string): Observable<ClaimListModel[]> {
    return this.http.get<ClaimListModel[]>(this.claimUrl);
  }

  /**
   * 拒否リスト削除依頼
   * @param list 依頼対象
   */
  reqDelete(list: ClaimListModel[]): void {
    //TODO

  }
}
