import { Injectable } from '@angular/core';
import { Router } from '@angular/router';
import { CommuterPassModel } from '../model/commuter-pass.model';

/**
 * 画面遷移サービス
 */
@Injectable({
  providedIn: 'root'
})
export class RouteService {
  //カード番号
  cardNumber?: string;

  //定期券情報
  commuterPassModel?: CommuterPassModel;

  //モード
  mode: number = 0;

  //利用者ID
  customerId?: string;

  //トークンID
  tokenId?: string;

  /**
   * コンストラクタ
   * @param router Router
   */
  constructor(private router: Router) { }

  /**
   * ホーム画面へ遷移
   */
  navigateHome() {
    this.router.navigate(['home']);
  }

  /**
   * クレジットカード選択画面へ遷移
   */
  navigateCardSelect() {
    this.router.navigate(['card-select'])
  }

  /**
   * クレジットカード登録画面へ遷移
   */
  navigateCardRegist() {
    this.router.navigate(['card-regist']);
  }

  /**
   * 定期券選択画面へ遷移
   * @param cardNumber カード番号
   */
  navigatePassSelect(tokenId?: string, cardNumber?: string) {
    this.tokenId = tokenId;
    this.cardNumber = cardNumber;
    this.router.navigate(['pass-select']);
  }

  /**
   * 定期券登録画面へ遷移
   */
  navigatePassRegist() {
    this.router.navigate(['pass-regist']);
  }

  /**
   * 請求一覧画面へ遷移
   */
  navigateClaimList() {
    this.router.navigate(['claim-list']);
  }
}
