import { Component, EventEmitter, Input, Output } from '@angular/core';
import { CreditCardModel } from 'src/app/model/credit-card.model';

/**
 * カード情報
 */
@Component({
  standalone: true,
  selector: 'app-card-info',
  templateUrl: './card-info.component.html',
  styleUrls: ['./card-info.component.scss'],
})
export class CardInfoComponent {
  //クレジットカード情報
  @Input() creditCardModel?: CreditCardModel;
  @Output() clickPass: EventEmitter<void> = new EventEmitter();
  @Output() clickTrash: EventEmitter<void> = new EventEmitter();

  /**
   * コンストラクタ
   */
  constructor() { }

  /**
   * 定期券
   */
  onClickPass(): void {
    this.clickPass.emit();
  }

  /**
   * 削除
   */
  onClickTrash(): void {
    this.clickTrash.emit();
  }
}
