import { Component, Input, OnInit } from '@angular/core';
import { DenyListModel } from 'src/app/model/deny-list.model';
import { RouteService } from 'src/app/services/route.service';

/**
 * 拒否リスト情報
 */
@Component({
  standalone: true,
  selector: 'app-deny-info',
  templateUrl: './deny-info.component.html',
  styleUrls: ['./deny-info.component.scss'],
})
export class DenyInfoComponent implements OnInit {
  @Input() model: DenyListModel = new DenyListModel();
  amountStr?: string;

  /**
   * コンストラクタ
   */
  constructor() { }

  /**
   * 初期化
   */
  ngOnInit(): void {
    this.amountStr = this.model.amount.toLocaleString();
  }

  /**
   * 選択イベント
   * @param event イベント情報
   */
  onChangeSelect(event: any) {
    this.model.select = event.target.checked;
  }

  /**
   * 拒否リスト情報取得
   * @returns 拒否リスト情報
   */
  getModel(): DenyListModel {
    return this.model;
  }
}
