import { Injectable } from '@angular/core';
import { CommuterPassModel } from '../model/commuter-pass.model';

/**
 * 定期券サービス
 */
@Injectable({
  providedIn: 'root'
})
export class PassService {
  /**
   * コンストラクタ
   */
  constructor() { }

  /**
   * 定期一覧取得
   * @param tokenId トークンID
   */
  getList(tokenId: string): CommuterPassModel[] {
    let commuterPassList = new Array();
    for (let i = 0; i < 2; i++) {
      let model: CommuterPassModel = new CommuterPassModel();
      model.routeId = "00000" + String(i);
      model.routeName = "【◯◯◯系統】XXXXX→XXXXX行き";
      model.startDate = "2024/07/01";
      model.useTermId = "2";
      model.useTermName = "3ヶ月";
      model.priceRangeId = "0";
      model.privateRangeName = "大人";
      model.getonStopName = "XXXXX";
      model.getoffStopName = "XXXXX";
      commuterPassList.push(model);
    }
    return commuterPassList;
  }

  /**
   * 定期券登録
   * @param model 定期券情報
   */
  regist(model: CommuterPassModel): void {
    //TODO
  }

  /**
   * 定期券区間変更
   * @param model 定期券情報
   */
  change(model: CommuterPassModel): void {
    //TODO
  }

  /**
   * 定期券継続
   * @param model 定期券情報
   */
  continue(model: CommuterPassModel): void {
    //TODO
  }

  /**
   * 定期券払戻
   * @param model 定期券情報
   */
  refund(model: CommuterPassModel): void {
    //TODO
  }

  /**
   * 路線一覧取得
   * @param agencyId 事業者ID
   * @returns 路線一覧
   */
  getRouteList(agencyId: string): Map<string, string> {
    //路線一覧
    let routeList = new Map();
    for (let i = 0; i < 5; i++) {
      let str = String(i + 1);
      routeList.set(str, "路線" + str);
    }
    return routeList;
  }

  /**
   * 使用期間一覧取得
   * @param agencyId 事業者ID
   * @returns 使用期間一覧
   */
  getUseTermList(agencyId: string): Map<string, string> {
    let useTermList = new Map();
    useTermList.set("1", "1ヶ月");
    useTermList.set("2", "3ヶ月");
    useTermList.set("6", "6ヶ月");

    return useTermList;
  }

  /**
   * 料金区分一覧取得
   * @param agencyId 事業者ID
   * @returns 料金区分一覧
   */
  getPriceRangeList(agencyId: string): Map<string, string> {
    let priceRangeList = new Map();
    priceRangeList.set("1", "大人");
    priceRangeList.set("2", "小児");
    priceRangeList.set("3", "学生");
    return priceRangeList;
  }

  /**
   * 停留所一覧取得
   * @param agencyId 事業者ID
   * @param routeId 路線ID
   * @returns 停留所一覧
   */
  getStopList(agencyId: string, routeId: string): Map<string, string> {
    let stopList = new Map();
    for (let i = 0; i < 5; i++) {
      let str = String(i + 1);
      stopList.set(str, "停留所" + str);
    }
    return stopList;
  }
}
