import { Component, OnInit, QueryList, ViewChildren } from '@angular/core';
import { ClaimListModel } from '../model/claim-list.model';
import { RouteService } from '../services/route.service';
import { ClaimInfoComponent } from './claim-info/claim-info.component';
import { ClaimlistService } from '../services/claimlist.service';

/**
 * 拒否リスト
 */
@Component({
  selector: 'app-claim-list',
  templateUrl: './claim-list.page.html',
  styleUrls: ['./claim-list.page.scss'],
})
export class ClaimListPage implements OnInit {
  public confirmButtons = [
    {
      text: 'いいえ',
      role: 'cancel'
    },
    {
      text: 'はい',
      role: 'confirm'
    },
  ];

  //請求一覧
  claimList?: ClaimListModel[];

  /**
   * コンストラクタ
   * @param routeService 画面遷移サービス
   * @param claimListService 請求一覧サービス
   */
  constructor(private routeService: RouteService, private claimListService: ClaimlistService) { }

  /**
   * 初期化
   */
  ngOnInit() {
    //this.claimList = this.claimListService.getList(this.routeService.customerId);
    this.claimListService.getList("").subscribe((ret: ClaimListModel[]) => {
      this.claimList = ret;
    });
  }

  /**
   * 戻る
   */
  onClickBack(): void {
    this.routeService.navigateHome();
  }

  /**
   * 支払要求
   * @param model 請求情報
   */
  onClickPayReq(model: ClaimListModel): void {
    if (this.claimList) {
      for (let i = 0; i < this.claimList.length; i++) {
        if (this.claimList[i].tokenId === model.tokenId && this.claimList[i].earningDate === model.earningDate) {
          this.claimList[i].payRequest = this.claimList[i].payRequest === 0 ? 1 : 0;
          break;
        }
      }
    }
  }

  onClickPrev(): void {

  }

  onClickNext(): void {

  }
}
