import { Component, OnInit } from '@angular/core';
import { CommuterPassModel } from '../model/commuter-pass.model';
import { RouteService } from '../services/route.service';
import { PassService } from '../services/pass.service';

/**
 * 定期券選択画面
 */
@Component({
  selector: 'app-pass-select',
  templateUrl: './pass-select.page.html',
  styleUrls: ['./pass-select.page.scss'],
})
export class PassSelectPage implements OnInit {
  //カード番号
  cardNumber?: string;
  //定期券情報
  commuterPassList?: CommuterPassModel[];

  /**
   * コンストラクタ
   * @param routeService 画面遷移サービス
   * @param passServiec 定期券サービス
   */
  constructor(private routeService: RouteService, private passService: PassService) {
    this.cardNumber = routeService.cardNumber;
  }

  /**
   * 初期化
   */
  ngOnInit(): void {
    if (this.routeService.tokenId) {
      //this.commuterPassList = this.passService.getList(this.routeService.tokenId);
      this.passService.getList(this.routeService.tokenId).subscribe((ret: CommuterPassModel[]) => {
        this.commuterPassList = ret;
      });
    }
  }

  /**
   * 戻る
   */
  onClickBack(): void {
    this.routeService.navigateCardSelect();
  }

  /**
   * 定期券払戻
   * @param model 定期券情報
   */
  onClickCancel(model: CommuterPassModel): void {

  }

  /**
   * 定期券登録
   */
  onClickAddPass(): void {
    this.routeService.navigatePassRegist();
  }
}
