import { Component } from '@angular/core';
import { RouteService } from '../services/route.service';

/**
 * メニュー画面
 */
@Component({
  selector: 'app-menu',
  templateUrl: './menu.page.html',
  styleUrls: ['./menu.page.scss'],
})
export class MenuPage {

  /**
   * コンストラクタ
   * @param routeServive 画面遷移サービス
   */
  constructor(private routeServive: RouteService) { }


  /**
   * ログアウト
   */
  onClickLogout(): void {
    this.routeServive.navigateHome();
  }

  /**
   * クレジットカード選択
   */
  onClickCardSelect(): void {
    this.routeServive.navigateCardSelect();
  }

  /**
   * 乗降履歴
   */
  onClickHistory(): void {
    this.routeServive.navigateHistory();
  }

  /**
   * 拒否リスト
   */
  onClickDenyList(): void {
    this.routeServive.navigateDenyList();
  }
}
